<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.


// Added by local_och5pcore plugin - please do not remove it manually.
/**
 * Opencast H5P Core renderers functions
 * 
 * @package    local_och5pcore
 * @copyright  2021 Farbod Zamani Boroujeni, ELAN e.V.
 * @author     Farbod Zamani Boroujeni <zamani@elan-ev.de>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

if (file_exists($CFG->dirroot . '/h5p/classes/output/renderer.php')) {
    // Be sure to include the H5P renderer so it can be extended.
    require_once($CFG->dirroot . '/h5p/classes/output/renderer.php');
    
    /**
    * Class theme_trema_core_h5p_renderer
    *
    * Extends the H5P renderer so that we are able to override the relevant
    * functions declared there.
    */
    class theme_trema_core_h5p_renderer extends core_h5p\output\renderer {
        
        /**
        * Add styles when an H5P is displayed.
        *
        * @param array $styles Styles that will be applied.
        * @param array $libraries Libraries that wil be shown.
        * @param string $embedType How the H5P is displayed.
        */
        public function h5p_alter_styles(&$styles, $libraries, $embedType) {
            global $CFG;
            if (
                isset($libraries['H5P.InteractiveVideo']) &&
                $libraries['H5P.InteractiveVideo']['majorVersion'] == '1'
            ) {
                $styles[] = (object) array(
                    'path'    => $CFG->httpswwwroot . '/local/och5pcore/lib/style/H5PEditor.AV.css',
                    'version' => '?ver=0.0.1',
                );
                $styles[] = (object) array(
                    'path'    => $CFG->httpswwwroot . '/local/och5pcore/lib/style/oc-fonts.css',
                    'version' => '?ver=0.0.1',
                );
            }
        }
            
        /**
        * Add scripts when an H5P is displayed.
        *
        * @param object $scripts Scripts that will be applied.
        * @param array $libraries Libraries that will be displayed.
        * @param string $embedType How the H5P is displayed.
        */
        public function h5p_alter_scripts(&$scripts, $libraries, $embedType) {
            global $PAGE, $CFG, $COURSE;
            if (
                isset($libraries['H5P.InteractiveVideo']) &&
                $libraries['H5P.InteractiveVideo']['majorVersion'] == '1'
            ) {
                $scripts[] = (object) array(
                    'path'    => $CFG->httpswwwroot . '/local/och5pcore/lib/js/H5PRunLTI.js',
                    'version' => '?ver=0.0.1',
                );
                $scripts[] = (object) array(
                    'path'    => $CFG->httpswwwroot . '/local/och5pcore/lib/js/H5PEditor.AV.js',
                    'version' => '?ver=0.0.1',
                );
            }
        }
    }
}
// End of local_och5pcore code block.