define("block_opencast/block_manage_series",["exports","block_opencast/tabulator","jquery","core/str","core/modal_factory","core/modal_events","core/fragment","core/ajax","core/templates","core/notification"],(function(_exports,_tabulator,_jquery,str,_modal_factory,_modal_events,_fragment,_ajax,_templates,_notification){function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Javascript to initialise the opencast block settings.
   *
   * @module     block/opencast
   * @copyright  2021 Tamara Gunkel, University of Münster
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */function getBody(contextid,ocinstanceid,seriesid,formdata){void 0===formdata&&(formdata="");var params={ocinstanceid:ocinstanceid,seriesid:seriesid,jsonformdata:formdata};return _fragment.default.loadFragment("block_opencast","series_form",contextid,params)}function submitFormAjax(e){e.preventDefault();var modal=e.data.modal,contextid=e.data.contextid,seriestable=window.seriestable,edited=e.data.edited,numseriesallowed=e.data.numseriesallowed,changeEvent=document.createEvent("HTMLEvents");changeEvent.initEvent("change",!0,!0),modal.getRoot().find(":input").each((function(index,element){element.dispatchEvent(changeEvent)}));var invalid=_jquery.default.merge(modal.getRoot().find('[aria-invalid="true"]'),modal.getRoot().find(".error"));if(invalid.length)invalid.first().focus();else{var formData=modal.getRoot().find("form").serialize(),seriestitle=(0,_jquery.default)(".modal #id_title").val();_ajax.default.call([{methodname:"block_opencast_submit_series_form",args:{contextid:contextid,ocinstanceid:e.data.ocinstanceid,seriesid:e.data.seriesid,jsonformdata:formData},done:function(newseries){if(modal.destroy(),edited){seriestable.getRows().find((r=>r.getData().series===e.data.seriesid)).update({seriesname:seriestitle})}else{var s=JSON.parse(newseries);seriestable.addRow({seriesname:s.seriestitle,series:s.series,isdefault:s.isdefault}),seriestable.getRows().length>=numseriesallowed&&((0,_jquery.default)("#createseries").hide(),(0,_jquery.default)("#importseries").hide())}},fail:function(er){"metadataseriesupdatefailed"===er.errorcode?(modal.destroy(),displayError(er.message)):modal.setBody(getBody(contextid,e.data.ocinstanceid,e.data.seriesid,formData))}}])}}function displayError(message){var context={announce:!0,closebutton:!0,extraclasses:"",message:message};_templates.default.render("core/notification_error",context).then((function(m){(0,_jquery.default)("#user-notifications").append(m)})).fail((function(){_notification.default.alert(message,message)}))}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_tabulator=_interopRequireDefault(_tabulator),_jquery=_interopRequireDefault(_jquery),str=function(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}newObj.default=obj,cache&&cache.set(obj,newObj);return newObj}(str),_modal_factory=_interopRequireDefault(_modal_factory),_modal_events=_interopRequireDefault(_modal_events),_fragment=_interopRequireDefault(_fragment),_ajax=_interopRequireDefault(_ajax),_templates=_interopRequireDefault(_templates),_notification=_interopRequireDefault(_notification);_exports.init=(contextid,ocinstanceid,createseries,series,numseriesallowed)=>{str.get_strings([{key:"seriesname",component:"block_opencast"},{key:"form_seriesid",component:"block_opencast"},{key:"default",component:"block_opencast"},{key:"noconnectedseries",component:"block_opencast"},{key:"createseriesforcourse",component:"block_opencast"},{key:"delete_series",component:"block_opencast"},{key:"delete_confirm_series",component:"block_opencast"},{key:"editseries",component:"block_opencast"},{key:"delete",component:"moodle"},{key:"loading",component:"block_opencast"},{key:"importseries",component:"block_opencast"},{key:"importfailed",component:"block_opencast"},{key:"form_seriesid",component:"block_opencast"},{key:"setdefaultseries_heading",component:"block_opencast"},{key:"setdefaultseries",component:"block_opencast"}]).then((function(jsstrings){var seriestable=new _tabulator.default("#seriestable",{data:series,layout:"fitColumns",placeholder:jsstrings[3],headerSort:!1,dataLoaded:function(data){!function(contextid,ocinstanceid,series,seriestable,row){_ajax.default.call([{methodname:"block_opencast_get_series_titles",args:{contextid:contextid,ocinstanceid:ocinstanceid,series:JSON.stringify(series)},done:function(data){var titles=JSON.parse(data);null!==seriestable?seriestable.getRows().forEach((function(row){row.update({seriesname:titles[row.getData().series]})})):row.update({seriesname:titles[row.getData().series]})},fail:function(error){null!==seriestable?seriestable.getRows().forEach((function(row){row.update({seriesname:error.message})})):row.update({seriesname:error.message})}}])}(contextid,ocinstanceid,data.map((x=>x.series)),this)},columns:[{title:jsstrings[0],field:"seriesname",editable:!1},{title:jsstrings[1],field:"series",editable:!1},{title:jsstrings[2],field:"isdefault",hozAlign:"center",widthGrow:0,formatter:function(cell){var input=document.createElement("input");return input.type="radio",input.name="defaultseries",input.checked=cell.getValue(),input.classList.add("ignoredirty"),input.addEventListener("click",(function(e){e.preventDefault(),_modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL,title:jsstrings[13],body:jsstrings[14]}).then((function(modal){modal.getRoot().on(_modal_events.default.hidden,(function(){modal.destroy()})),modal.getRoot().on(_modal_events.default.save,(function(){_ajax.default.call([{methodname:"block_opencast_set_default_series",args:{contextid:contextid,ocinstanceid:ocinstanceid,seriesid:cell.getRow().getData().series},done:function(){modal.destroy(),cell.getTable().getRows().forEach((function(row){row===cell.getRow()?row.update({isdefault:1}):row.update({isdefault:0})}))},fail:function(e){modal.destroy(),displayError(e.message)}}])})),modal.show()})).catch(_notification.default.exception)})),input}},{title:"",width:40,headerSort:!1,hozAlign:"center",formatter:function(){return'<i class="icon fa fa-edit fa-fw"></i>'},cellClick:function(_,cell){_modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL,title:jsstrings[7],body:getBody(contextid,ocinstanceid,cell.getRow().getCell("series").getValue())}).then((function(modal){modal.setSaveButtonText(jsstrings[7]),modal.setLarge(),modal.getRoot().on(_modal_events.default.hidden,(function(){modal.destroy()})),modal.getRoot().on(_modal_events.default.shown,(function(){modal.getRoot().append("<style>[data-fieldtype=submit] { display: none ! important; }</style>")})),modal.getRoot().on(_modal_events.default.save,(function(e){e.preventDefault(),modal.getRoot().find("form").submit()})),modal.getRoot().on("submit","form",{modal:modal,contextid:contextid,ocinstanceid:ocinstanceid,seriesid:cell.getRow().getCell("series").getValue(),numseriesallowed:numseriesallowed,edited:!0},submitFormAjax),modal.show()})).catch(_notification.default.exception)}},{title:"",width:40,headerSort:!1,hozAlign:"center",formatter:function(){return'<i class="icon fa fa-trash fa-fw"></i>'},cellClick:function(e,cell){_modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL,title:jsstrings[5],body:jsstrings[6]}).then((function(modal){modal.setSaveButtonText(jsstrings[8]),modal.getRoot().on(_modal_events.default.save,(function(){_ajax.default.call([{methodname:"block_opencast_unlink_series",args:{contextid:contextid,ocinstanceid:ocinstanceid,seriesid:cell.getRow().getData().series},done:function(result){modal.destroy();let res=JSON.parse(result);if(res.error)displayError(res.message);else{cell.getRow().delete();const createseries=(0,_jquery.default)("#createseries"),importseries=(0,_jquery.default)("#importseries");createseries.show(),createseries.removeClass("d-none"),importseries.show(),importseries.removeClass("d-none")}},fail:function(e){modal.destroy(),displayError(e.message)}}])})),modal.show()})).catch(_notification.default.exception)}}]});window.seriestable=seriestable,(0,_jquery.default)("#createseries").click((function(){_modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL,title:jsstrings[4],body:getBody(contextid,ocinstanceid,"",void 0)}).then((function(modal){modal.setSaveButtonText(jsstrings[4]),modal.setLarge(),modal.getRoot().on(_modal_events.default.hidden,(function(){modal.destroy()})),modal.getRoot().on(_modal_events.default.shown,(function(){modal.getRoot().append("<style>[data-fieldtype=submit] { display: none ! important; }</style>")})),modal.getRoot().on(_modal_events.default.save,(function(e){e.preventDefault(),modal.getRoot().find("form").submit()})),modal.getRoot().on("submit","form",{modal:modal,contextid:contextid,ocinstanceid:ocinstanceid,seriesid:"",numseriesallowed:numseriesallowed,edited:!1},submitFormAjax),modal.show()})).catch(_notification.default.exception)})),(0,_jquery.default)("#importseries").click((function(){let context={label:jsstrings[12],required:!1,advanced:!1,element:{wrapperid:"importseriesid_wrapper",name:"importseriesid",id:"importseriesid",type:"text",size:40,value:""}};_modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL,title:jsstrings[10],body:_templates.default.render("core_form/element-text",context)}).then((function(modal){modal.setSaveButtonText(jsstrings[10]),modal.setLarge(),modal.getRoot().on(_modal_events.default.hidden,(function(){modal.destroy()})),modal.getRoot().on(_modal_events.default.save,(function(e){e.preventDefault();var seriesid=(0,_jquery.default)("#importseriesid").val();_ajax.default.call([{methodname:"block_opencast_import_series",args:{contextid:contextid,ocinstanceid:ocinstanceid,seriesid:seriesid},done:function(newseries){if(modal.destroy(),void 0!==seriestable){var s=JSON.parse(newseries);seriestable.addRow({seriesname:s.title,series:s.id,isdefault:s.isdefault}),seriestable.getRows().length>=numseriesallowed&&((0,_jquery.default)("#createseries").hide(),(0,_jquery.default)("#importseries").hide())}},fail:function(){modal.destroy(),displayError(jsstrings[11])}}])})),modal.show()})).catch(_notification.default.exception)})),createseries&&(0,_jquery.default)("#createseries").trigger("click")})).catch(_notification.default.exception)}}));

//# sourceMappingURL=block_manage_series.min.js.map