<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language file.
 *
 * @package     theme_trema
 * @copyright   2019 Trema - {@link https://trema.tech/}
 * @author      Rodrigo Mady
 * @author      Trevor Furtado
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

// Theme strings.
$string['activecourses'] = 'Active Courses';
$string['activeenrollments'] = 'Active Enrollments';
$string['adminarea'] = 'Only Administrators can see blocks in this area.';
$string['alert'] = 'Alert';
$string['backgroundcolor'] = 'Background color';
$string['cachedef_dashboardadmin'] = 'Cache for Admin dashboard';
$string['card'] = 'Card';
$string['cardicon'] = 'Card icon';
$string['cardicon_desc'] = 'See here the list of all Font Awesome available icons: <a href="https://fontawesome.com/v4.7.0/icons/" target="_blank">https://fontawesome.com/v4.7.0/icons/</a>';
$string['cardiconcolor'] = 'Card icon color';
$string['cardlink'] = 'Card link';
$string['cardsubtitle'] = 'Card subtitle';
$string['cardtitle'] = 'Card title';
$string['circlescolor'] = 'Circles color';
$string['choosereadme'] = 'Trema is built on to the new Moodle Boost theme, using Bootstrap4 and Mustache templates.';
$string['configtitle'] = 'Trema';
$string['coursescards'] = 'Courses cards';
$string['defaultfrontpagebody'] = 'Frontpage Body';
$string['defaultfrontpagebody_desc'] = 'Default content from frontpage body';
$string['defaultfooter'] = 'Footer';
$string['defaultfooter_desc'] = 'Default content from footer';
$string['diskusage'] = 'Moodledata disk usage';
$string['content'] = 'Content';
$string['defaultfrontpagefooter'] = 'Frontpage Footer';
$string['defaultfrontpagefooter_desc'] = 'Default content from frontpage footer';
$string['enableadmindashboard'] = 'Enable Admin Dashboard';
$string['enabletrematopics'] = 'Enable Trema Course Style for Topics';
$string['enabletrematopics_desc'] = 'Enable Trema Course Style for Course format Topics: <img class="img-responsive" src="{$a}"/>';
$string['enableadmindashboard_desc'] = 'Uncheck if you want to hide the area below in admin dashboard: <img class="img-responsive" src="{$a}"/>';
$string['enablefooterinfo'] = 'Enable Footer Info and Trema info';
$string['enablefooterinfo_desc'] = 'Uncheck if you want to hide the area below in footer: <img class="img-responsive" src="{$a}"/>';
$string['favicon'] = 'Custom favicon';
$string['favicon_desc'] = 'Upload your own favicon. It should be an .ico file.';
$string['footertitle'] = 'Theme Trema';
$string['frontpagebanner'] = 'Frontpage banner.';
$string['frontpagebanner_desc'] = 'Upload the image file to be inserted in frontpage. Will replace the default image of a forest.';
$string['frontpagebuttontext'] = 'Frontpage button text';
$string['frontpagebuttonclass'] = 'Frontpage button HTML class';
$string['frontpagebuttonclass_desc'] = 'You can change the style of the button choosing another class.';
$string['frontpagebuttonhref'] = 'Frontpage button href';
$string['frontpagebuttonhref_desc'] = 'Choose the value of the button\'s href attribute.';
$string['frontpagecards'] = 'Frontpage cards';
$string['frontpagecontent'] = 'Frontpage Content';
$string['frontpageenablecards'] = 'Enable frontpage cards';
$string['frontpageenablecards_desc'] = 'Uncheck if you want to hide the area below: <img class="img-responsive" src="{$a}" />';
$string['frontpagesubtitle'] = 'Frontpage subtitle.';
$string['frontpagetitle'] = 'Frontpage title.';
$string['image'] = 'Background image';
$string['login'] = 'Login';
$string['loginpagecreatefirst'] = 'Display \'Create account\' box first';
$string['loginpagecreatefirst_desc'] = 'If checked, display the \'Create account\' box first. The default is to display the login box first.';
$string['loginpagestyle'] = 'Login page style';
$string['loginbackgroundimage'] = 'Login background image';
$string['numberofcards'] = 'Number of cards';
$string['particlecircles'] = 'Particle.js Circles';
$string['pluginname'] = 'Trema';
$string['preset'] = 'Theme preset';
$string['preset_desc'] = 'Pick a preset to broadly change the look of the theme.';
$string['privacy:metadata'] = 'The Trema theme does not store any individual user data.';
$string['region-side-admin'] = 'Only admins';
$string['region-side-pre'] = 'Right';
$string['rememberusername'] = 'Remember user';
$string['seemore'] = 'See more';
$string['showmycourses'] = 'Show my courses';
$string['showmycourses_desc'] = 'Show enrolled courses in navbar';
$string['styleguide'] = 'Style Guide';
$string['systemsecurity'] = 'System Security';
$string['summarybutton_text'] = 'Course Description';
$string['summarycourselink_text'] = 'Go To Course';
$string['summarytype'] = 'Summary type';
$string['summarytype_desc'] = 'Choose whether the course summary will open in a modal or popover.';
$string['title'] = 'Title';
$string['total'] = 'Total';
$string['subtitle'] = 'Subtitle';

// Strings copied from Boost.
$string['advancedsettings'] = 'Advanced settings';
$string['primarycolor'] = 'Primary colour';
$string['primarycolor_desc'] = 'The main colour.';
$string['secondarycolor'] = 'Secondary colour';
$string['secondarycolor_desc'] = 'The secondary colour.';
$string['generalsettings'] = 'General settings';
$string['rawscss'] = 'Raw SCSS';
$string['rawscss_desc'] = 'Use this field to provide SCSS or CSS code which will be injected at the end of the style sheet.';
$string['rawscsspre'] = 'Raw initial SCSS';
$string['rawscsspre_desc'] = 'In this field you can provide initialising SCSS code, it will be injected before everything else. Most of the time you will use this setting to define variables.';

// Frontpage Image.
$string['carrouselbtntext'] = 'Button text {$a}';
$string['carrouselbtntext_desc'] = 'Button text for link in frontpage image {$a}.';
$string['carrouselbtnhref'] = 'Button link {$a}';
$string['carrouselbtnhref_desc'] = 'Button link for frontpage image {$a}.';
$string['carrouselbtnclass'] = 'Frontpage button HTML class';
$string['carrouselbtnclass_desc'] = 'You can change the style of the button by choosing a different class.';
$string['frontpageimages'] = 'Frontpage images';
$string['frontpageimage'] = 'Frontpage image {$a}';
$string['frontpageimage_desc'] = 'Image {$a} to show in frontpage banner.';
$string['image'] = 'Image {$a}';
$string['imagelink'] = 'Image link';
$string['imagelink_desc'] = 'Button with link in image {$a}.';
$string['numberofimages']  = "Number of images in frontpage banner";
$string['numberofimages_desc']  = "Number of images to show in frontpage banner. If is more than one, loads the carousel.";
$string['title_desc']  = 'Title to show in frontpage image {$a}';
$string['subtitle_desc']  = 'Subtitle to show in frontpage image {$a}';

$string['frontpagetitle_default'] = 'Banner title';
$string['frontpagesubtitle_default'] = 'This is a banner subtitle,<br>with multiple lines of text.';
$string['frontpagebuttontext_default'] = 'Learn more';
$string['frontpagecardstitle'] = 'Title of cards section';
$string['frontpagecardssubtitle'] = 'The description of the cards section goes here. Several lines of text can be placed in this space.';
$string['cardtitle_default'] = 'Card Title';
$string['cardsubtitle_default'] = 'The description of this card goes here. Several lines of text can be placed in this space.';
$string['subtitle_default'] = 'This is the default sub-title. You can modify or remove this in the Trema theme settings.';
$string['defaultfooter_default'] = '<div class="row">
	<div class="col-md-8">
		<h3 class="-align-center">Trema Solutions in Technology</h3>

	</div>
	<div class="col-md-4">
		<h3>Contact Us</h3>

		<ul class="labeled-icons">
			<li>
                <span class="fa fa-globe fa-2x"></span>
                <a href="https://trema.tech/" target="_blank" style="cursor: pointer;">
                    <p>https://trema.tech/</p>
                </a>
            </li>
			<li>
                <span class="fa fa-github fa-2x"></span>
                <a href="https://github.com/trema-tech/" target="_blank" style="cursor: pointer;">
                    <p>https://github.com/trema-tech/</p>
                </a>
            </li>
		</ul>
	</div>
</div>';
