<?php
/**
 * config 
 * 
 * @package    theme_aigne
 * @copyright  2013-2020 _ Franc Pombal _ www.aigne.com
 * @license    http://www.gnu.org/copyleft/gpl.html _ GNU GPL v3 or later
 */
defined('MOODLE_INTERNAL') || die();

// Name of the theme. Most likely the name of the directory in which this file resides.
$THEME->name = 'aigne';

// Determine if this theme is compliant with html5
$THEME->doctype = 'html5';

// Which existing theme(s) in the /theme/ directory do you want this theme to extend.
//$THEME->parents = ['base'];
$THEME->parents = ['classic'];

// An array of stylesheets not to inherit from the themes parents (We don't want these)
$THEME->parents_exclude_sheets = ['classic'=>[
    'pagelayout', 
    'core',
    'base',
    'standard',
    'course',
    'coursecategory',
    'incourse',
    'frontpage',
    'admin',
    'mydashboard',
    'mypublic',
    'login',
    'popup',
    'frametop',
    'embedded',
    'maintenance',
    'print',
    'redirect',
    'report',
    'secure'  
]];

 
// An array of plugin sheets to ignore and not include.
// $THEME->plugins_exclude_sheets

// Categories List Style defined in Admin -> Apperance -> Themes -> AIGNE -> "catstyle"
    $catstyle = (empty($THEME->settings->catstyle)) ? false : ($THEME->settings->catstyle);
    switch ($catstyle) {
        case 0:
            $catstyle = '';
            break;
        case 1:
            $catstyle = 'aigne_cat1';
            break;
        case 2:
            $catstyle = 'aigne_cat2';
            break;
        default:
            $catstyle = '';
            break;
    }
// Name of the stylesheet(s) you've including in this theme's /styles/ directory.
$THEME->sheets = array(
    'aigne_pagelayout',  // Must come first: page layout
    'aigne_style',       // Must come second: default styles, including 'course', 'filemanager',
    'aigne_base',        // To avoid and to correct the style of the parent theme    
    'aigne_menu',
    'aigne_block',
    'aigne_mod',         // including 'calendar', 'glossary', 'forum', 'grade', (pending 'message', 'question',)
    'aigne_dialogue',    // Messages and Activities Selector
    $catstyle,
    'aigne_fonta',    
    'aigne_custom'
);

// An array of stylesheets to include within the body of the editor.
$THEME->editor_sheets = array('aigne_editor');

// Una opción para ocultar 'side-post' en 'incourse' según la configuración del tema
    $coursall = (empty($THEME->settings->contentcur)) ? false : ($THEME->settings->contentcur);
    $activall = (empty($THEME->settings->contentact)) ? false : ($THEME->settings->contentact);

// These are all of the possible layouts in Moodle.
$THEME->layouts = array(
    // Most backwards compatible layout without the blocks
    // ► Logout Confirmation Message + Change password + Dividir mensaje en foro
    'base' => array(
        'file' => 'default.php',
        'regions' => array('side-post'),
        'defaultregion' => 'side-post',
        'options' => array('langmenu'=>true, 'nologininfo'=>true, 'nocustommenu'=>true, 'nonavbar'=>false, 
                           'noblocks'=>true, 'nocourseheaderfooter'=>true, 'nocoursefooter'=>true, 'nofooter'=>true, 'infobanner'=>false),         
    ),
    // Standard layout with blocks, this is recommended for most pages with default information
    // ► Viewing a profile + Viewing a calendar
    'standard' => array(
        'file' => 'default.php',
        'regions' => array('side-post'),
        'defaultregion' => 'side-post',
        'options' => array('langmenu'=>true, 'nologininfo'=>true, 'nocustommenu'=>false, 'nonavbar'=>false,
                           'noblocks'=>false, 'nocourseheaderfooter'=>false, 'nocoursefooter'=>false, 'nofooter'=>true, 'infobanner'=>false),                      
    ),
    // ► LOGIN PAGE
    'login' => array(
        'file' => 'default.php',
        'regions' => array(),
        'defaultregion' => '',
        'options' => array('langmenu'=>true, 'nologininfo'=>true, 'nocustommenu'=>true, 'nonavbar'=>true,
                           'noblocks'=>true, 'nocourseheaderfooter'=>true, 'nocoursefooter'=>true, 'nofooter'=>false, 'infobanner'=>false),
    ),
    // The site home page. 
    // ► Frontpage before and after login
    'frontpage' => array(
        'file' => 'default.php',
        'regions' => array('side-post'),
        'defaultregion' => 'side-post',
        'options' => array('langmenu'=>true, 'nologininfo'=>true, 'nocustommenu'=>false, 'nonavbar'=>false,
                           'noblocks'=>false, 'nocourseheaderfooter'=>true, 'nocoursefooter'=>true, 'nofooter'=>false, 'infobanner'=>true),
    ),
    // ► Help pages, called by the Navigation Help Bar on footer.
    'aigne1' => array(
        'file' => 'page2.php',
        'regions' => array(),
        'options' => array('langmenu'=>true, 'nologininfo'=>true, 'nocustommenu'=>true, 'nonavbar'=>false,
                           'noblocks'=>true, 'nocourseheaderfooter'=>true, 'nocoursefooter'=>true, 'nofooter'=>false, 'infobanner'=>false),
    ),   
    // ► Only categories list or courses list in specific category page
    'coursecategory' => array(
        'file' => 'default.php',
        'regions' => array('side-post'),
        'defaultregion' => 'side-post',
        'options' => array('langmenu'=>true, 'nologininfo'=>true, 'nocustommenu'=>false, 'nonavbar'=>false,
                           'noblocks'=>false, 'nocourseheaderfooter'=>false, 'nocoursefooter'=>false, 'nofooter'=>false, 'infobanner'=>true),
    ),
    // ► Main course page
    'course' => array(
        'file' => 'default.php',
        'regions' => array('side-post'),
        'defaultregion' => 'side-post',
        'options' => array('langmenu'=>false, 'nologininfo'=>true, 'nocustommenu'=>true, 'nonavbar'=>false,
                           'noblocks'=>$coursall, 'nocourseheaderfooter'=>false, 'nocoursefooter'=>false, 'nofooter'=>true, 'infobanner'=>false),
    ),
    // Part of course, typical for modules 
    // ► ACTIVITY OR RESOURCE PAGE
    'incourse' => array(
        'file' => 'default.php',
        'regions' => array('side-post'),
        'defaultregion' => 'side-post',
        'options' => array('langmenu'=>false, 'nologininfo'=>true, 'nocustommenu'=>true, 'nonavbar'=>false,
                           'noblocks'=>$activall, 'nocourseheaderfooter'=>false, 'nocoursefooter'=>false, 'nofooter'=>true, 'infobanner'=>false),
    ),
    // ► My Moodle (Personal Area) page
    'mydashboard' => array(
        'file' => 'default.php',
        'regions' => array('side-post'),
        'defaultregion' => 'side-post',
        'options' => array('langmenu'=>true, 'nologininfo'=>true, 'nocustommenu'=>false, 'nonavbar'=>false,
                           'noblocks'=>false, 'nocourseheaderfooter'=>false, 'nocoursefooter'=>false, 'nofooter'=>true, 'infobanner'=>false),
    ),
    // ► My (Public) Profile page
    'mypublic' => array(
        'file' => 'default.php',
        'regions' => array('side-post'),
        'defaultregion' => 'side-post',
        'options' => array('langmenu'=>true, 'nologininfo'=>true, 'nocustommenu'=>false, 'nonavbar'=>false,
                           'noblocks'=>false, 'nocourseheaderfooter'=>false, 'nocoursefooter'=>false, 'nofooter'=>false, 'infobanner'=>false),
    ), 
    // ► Server administration scripts.
    'admin' => array(
        'file' => 'default.php',
        'regions' => array('side-pre'),
        'defaultregion' => 'side-pre',
        'options' => array('langmenu'=>true, 'nologininfo'=>true, 'nocustommenu'=>false, 'nonavbar'=>false,
                           'noblocks'=>false, 'nocourseheaderfooter'=>true, 'nocoursefooter'=>true, 'nofooter'=>true, 'infobanner'=>false),
    ),
    // The pagelayout used for reports. 
    // ► Site Administration -> Reports...
    'report' => array(
        'file' => 'default.php',
        'regions' => array('side-pre'),
        'defaultregion' => 'side-pre',
        'options' => array('langmenu'=>false, 'nologininfo'=>true, 'nocustommenu'=>true, 'nonavbar'=>false,
                           'noblocks'=>false, 'nocourseheaderfooter'=>true, 'nocoursefooter'=>true, 'nofooter'=>false, 'infobanner'=>false),
    ),
    // Embedded pages, like iframe/object embeded in moodleform - it needs as much space as possible
    'embedded' => array(
        'file' => 'page1.php',
        'regions' => array(),
        'options' => array('langmenu'=>false, 'nologininfo'=>true, 'nocustommenu'=>true, 'nonavbar'=>true,
                           'noblocks'=>true, 'nocourseheaderfooter'=>true, 'nocoursefooter'=>true, 'nofooter'=>true, 'infobanner'=>false),
    ),
    // The pagelayout used when a redirection is occuring.
    // ► Purge cache + Send forum message
    'redirect' => array(
        'file' => 'page1.php',
        'regions' => array(),
        'options' => array('langmenu'=>false, 'nologininfo'=>true, 'nocustommenu'=>true, 'nonavbar'=>true,
                           'noblocks'=>true, 'nocourseheaderfooter'=>true, 'nocoursefooter'=>true, 'nofooter'=>true, 'infobanner'=>false),
    ),
    // POPUP _ Used during upgrade and install, and for the 'This site is undergoing maintenance' message.
    'maintenance' => array(
        'file' => 'default.php',
        'regions' => array(),
        'options' => array('langmenu'=>false, 'nologininfo'=>true, 'nocustommenu'=>true, 'nonavbar'=>true,
                           'noblocks'=>true, 'nocourseheaderfooter'=>true, 'nocoursefooter'=>true, 'nofooter'=>true, 'infobanner'=>false),
    ),
    // POPUP _ Pages that appear in pop-up windows
    // ► ADMIN -> REPORTS + 
    'popup' => array(
        'file' => 'default.php',
        'regions' => array(),
        'options' => array('langmenu'=>false, 'nologininfo'=>true, 'nocustommenu'=>true, 'nonavbar'=>false,
                           'noblocks'=>true, 'nocourseheaderfooter'=>true, 'nocoursefooter'=>true, 'nofooter'=>true, 'infobanner'=>false),
    ),
    // The pagelayout used for safebrowser and securewindow.
    'secure' => array(
        'file' => 'default.php',
        'regions' => array('side-post'),
        'defaultregion' => 'side-post',
        'options' => array('langmenu'=>false, 'nologininfo'=>true, 'nocustommenu'=>true, 'nonavbar'=>true,
                           'noblocks'=>false, 'nocourseheaderfooter'=>true, 'nocoursefooter'=>true, 'nofooter'=>false, 'infobanner'=>false),
    ),
    // No blocks and minimal footer - used for legacy frame layouts only!
    // Actividades Externas + 
    'frametop' => array(
        'file' => 'default.php',
        'regions' => array(),
        'options' => array('langmenu'=>false, 'nologininfo'=>true, 'nocustommenu'=>true, 'nonavbar'=>false,
                           'noblocks'=>true, 'nocourseheaderfooter'=>true, 'nocoursefooter'=>true, 'nofooter'=>true, 'infobanner'=>false),
    ),
    // Should display the content and basic headers only.
    'print' => array(
        'file' => 'default.php',
        'regions' => array(),
        'options' => array('langmenu'=>false, 'nologininfo'=>true, 'nocustommenu'=>true, 'nonavbar'=>true,
                           'noblocks'=>true, 'nocourseheaderfooter'=>true, 'nocoursefooter'=>true, 'nofooter'=>false, 'infobanner'=>false),
    ),
);


$THEME->editor_sheets = [];
$THEME->enable_dock = true;
$THEME->hidefromselector = false;
// $THEME->larrow = $THEME->settings->bcsep;
// $THEME->rarrow
// $THEME->filter_mediaplugin_colors
// $THEME->resource_mp3player_colors
// $THEME->javascripts = array();
// $THEME->javascripts_footer = array();
// $THEME->parents_exclude_javascripts

// New in moodle 2.7.0
// $THEME->csstreepostprocessor = 'theme_boost_css_tree_post_processor';
// $THEME->extrascsscallback = 'theme_boost_get_extra_scss';
// $THEME->prescsscallback = 'theme_boost_get_pre_scss';
// $THEME->precompiledcsscallback = 'theme_boost_get_precompiled_css';
// $THEME->yuicssmodules = array();
$THEME->rendererfactory = 'theme_overridden_renderer_factory';
$THEME->csspostprocess = 'theme_aigne_process_css';
$THEME->usefallback = true;
// $THEME->requiredblocks = '';
// $THEME->addblockposition = BLOCK_ADDBLOCK_POSITION_FLATNAV;
$THEME->iconsystem = '\theme_aigne\icon_system';
// $THEME->iconsystem = \core\output\icon_system::FONTAWESOME;

//TODO
//COURSECAT_SHOW_COURSES_NONE = 0; /* do not show courses at all */
//COURSECAT_SHOW_COURSES_COUNT = 5; /* do not show courses but show number of courses next to category name */
//COURSECAT_SHOW_COURSES_COLLAPSED = 10;
//COURSECAT_SHOW_COURSES_AUTO = 15; /* will choose between collapsed and expanded automatically */
//COURSECAT_SHOW_COURSES_EXPANDED = 20;
//COURSECAT_SHOW_COURSES_EXPANDED_WITH_CAT = 30;

/* END OF FILE */